package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Test033101;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITest033101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test033101前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Test033101Controller {

  @Autowired
  private ITest033101Service test033101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test033101 test033101
   * @return
   */
  @GetMapping("/test033101s" )
  public XfR getTest033101s(XfPage page, Test033101 test033101) {
    return XfR.ok(test033101ServiceImpl.page(page, Wrappers.query(test033101)));
  }

  /**
   * 通过id查询test033101
   * @param  id
   * @return XfR
   */
  @GetMapping("/test033101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test033101ServiceImpl.getById(id));
  }

  /**
   * 新增test033101
   * @param test033101 test033101
   * @return XfR
   */
  @PostMapping("/test033101s")
  public XfR save(@RequestBody Test033101 test033101) {
     return XfR.ok(test033101ServiceImpl.save(test033101));
  }

  /**
   * 修改-传入修改后的全部数据test033101
   * @param test033101 test033101
   * @return XfR
   */
  @PutMapping("/test033101s/{id}")
  public XfR putUpdate(@RequestBody Test033101 test033101,@PathVariable Long id) {
      test033101.setId(id);
      return XfR.ok(test033101ServiceImpl.updateById(test033101));
  }

  /**
   * 修改-传入修改的数据test033101
   * @param test033101 test033101
   * @return XfR
   */
  @PatchMapping("/test033101s/{id}")
  public XfR patchUpdate(@RequestBody Test033101 test033101,@PathVariable Long id) {
      Test033101 uptest033101 = test033101ServiceImpl.getById(id);
      if(uptest033101 != null){
        uptest033101 = ObjectCopyUtils.copyProperties(test033101,uptest033101,true);
      }
      return XfR.ok(test033101ServiceImpl.updateById(uptest033101));
  }

  /**
   * 通过id删除test033101
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test033101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test033101ServiceImpl.removeById(id));
  }

  @PostMapping("/test033101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test033101");
     params.put("request", condition);

     return XfR.ok(test033101ServiceImpl.querys(params));
  }

}
