package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Test0407;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITest0407Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test0407前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Test0407Controller {

  @Autowired
  private ITest0407Service test0407ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0407 test0407
   * @return
   */
  @GetMapping("/test0407s" )
  public XfR getTest0407s(XfPage page, Test0407 test0407) {
    return XfR.ok(test0407ServiceImpl.page(page, Wrappers.query(test0407)));
  }

  /**
   * 通过id查询test0407
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0407s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0407ServiceImpl.getById(id));
  }

  /**
   * 新增test0407
   * @param test0407 test0407
   * @return XfR
   */
  @PostMapping("/test0407s")
  public XfR save(@RequestBody Test0407 test0407) {
     return XfR.ok(test0407ServiceImpl.save(test0407));
  }

  /**
   * 修改-传入修改后的全部数据test0407
   * @param test0407 test0407
   * @return XfR
   */
  @PutMapping("/test0407s/{id}")
  public XfR putUpdate(@RequestBody Test0407 test0407,@PathVariable Long id) {
      test0407.setId(id);
      return XfR.ok(test0407ServiceImpl.updateById(test0407));
  }

  /**
   * 修改-传入修改的数据test0407
   * @param test0407 test0407
   * @return XfR
   */
  @PatchMapping("/test0407s/{id}")
  public XfR patchUpdate(@RequestBody Test0407 test0407,@PathVariable Long id) {
      Test0407 uptest0407 = test0407ServiceImpl.getById(id);
      if(uptest0407 != null){
        uptest0407 = ObjectCopyUtils.copyProperties(test0407,uptest0407,true);
      }
      return XfR.ok(test0407ServiceImpl.updateById(uptest0407));
  }

  /**
   * 通过id删除test0407
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0407s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0407ServiceImpl.removeById(id));
  }

  @PostMapping("/test0407s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0407");
     params.put("request", condition);

     return XfR.ok(test0407ServiceImpl.querys(params));
  }

}
