package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Test041201;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITest041201Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test041201前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Test041201Controller {

  @Autowired
  private ITest041201Service test041201ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test041201 test041201
   * @return
   */
  @GetMapping("/test041201s" )
  public XfR getTest041201s(XfPage page, Test041201 test041201) {
    return XfR.ok(test041201ServiceImpl.page(page, Wrappers.query(test041201)));
  }

  /**
   * 通过id查询test041201
   * @param  id
   * @return XfR
   */
  @GetMapping("/test041201s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test041201ServiceImpl.getById(id));
  }

  /**
   * 新增test041201
   * @param test041201 test041201
   * @return XfR
   */
  @PostMapping("/test041201s")
  public XfR save(@RequestBody Test041201 test041201) {
     return XfR.ok(test041201ServiceImpl.save(test041201));
  }

  /**
   * 修改-传入修改后的全部数据test041201
   * @param test041201 test041201
   * @return XfR
   */
  @PutMapping("/test041201s/{id}")
  public XfR putUpdate(@RequestBody Test041201 test041201,@PathVariable Long id) {
      test041201.setId(id);
      return XfR.ok(test041201ServiceImpl.updateById(test041201));
  }

  /**
   * 修改-传入修改的数据test041201
   * @param test041201 test041201
   * @return XfR
   */
  @PatchMapping("/test041201s/{id}")
  public XfR patchUpdate(@RequestBody Test041201 test041201,@PathVariable Long id) {
      Test041201 uptest041201 = test041201ServiceImpl.getById(id);
      if(uptest041201 != null){
        uptest041201 = ObjectCopyUtils.copyProperties(test041201,uptest041201,true);
      }
      return XfR.ok(test041201ServiceImpl.updateById(uptest041201));
  }

  /**
   * 通过id删除test041201
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test041201s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test041201ServiceImpl.removeById(id));
  }

  @PostMapping("/test041201s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test041201");
     params.put("request", condition);

     return XfR.ok(test041201ServiceImpl.querys(params));
  }

}
