package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.TestConvert;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestConvertService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestConvertController {

  @Autowired
  private ITestConvertService testConvertServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testConvert ${table.comment}
   * @return
   */
  @GetMapping("/testconverts" )
  public XfR getTestConverts(XfPage page, TestConvert testConvert) {
    return XfR.ok(testConvertServiceImpl.page(page, Wrappers.query(testConvert)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testconverts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testConvertServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testConvert ${table.comment}
   * @return XfR
   */
  @PostMapping("/testconverts")
  public XfR save(@RequestBody TestConvert testConvert) {
     return XfR.ok(testConvertServiceImpl.save(testConvert));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testConvert ${table.comment}
   * @return XfR
   */
  @PutMapping("/testconverts/{id}")
  public XfR putUpdate(@RequestBody TestConvert testConvert,@PathVariable Long id) {
      testConvert.setId(id);
      return XfR.ok(testConvertServiceImpl.updateById(testConvert));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testConvert ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testconverts/{id}")
  public XfR patchUpdate(@RequestBody TestConvert testConvert,@PathVariable Long id) {
      TestConvert uptestConvert = testConvertServiceImpl.getById(id);
      if(uptestConvert != null){
        uptestConvert = ObjectCopyUtils.copyProperties(testConvert,uptestConvert,true);
      }
      return XfR.ok(testConvertServiceImpl.updateById(uptestConvert));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testconverts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testConvertServiceImpl.removeById(id));
  }

  @PostMapping("/testconverts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_convert");
     params.put("request", condition);

     return XfR.ok(testConvertServiceImpl.querys(params));
  }

}
