package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testclass;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestclassService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testclass前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestclassController {

  @Autowired
  private ITestclassService testclassServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testclass testclass
   * @return
   */
  @GetMapping("/testclasss" )
  public XfR getTestclasss(XfPage page, Testclass testclass) {
    return XfR.ok(testclassServiceImpl.page(page, Wrappers.query(testclass)));
  }

  /**
   * 通过id查询testclass
   * @param  id
   * @return XfR
   */
  @GetMapping("/testclasss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testclassServiceImpl.getById(id));
  }

  /**
   * 新增testclass
   * @param testclass testclass
   * @return XfR
   */
  @PostMapping("/testclasss")
  public XfR save(@RequestBody Testclass testclass) {
     return XfR.ok(testclassServiceImpl.save(testclass));
  }

  /**
   * 修改-传入修改后的全部数据testclass
   * @param testclass testclass
   * @return XfR
   */
  @PutMapping("/testclasss/{id}")
  public XfR putUpdate(@RequestBody Testclass testclass,@PathVariable Long id) {
      testclass.setId(id);
      return XfR.ok(testclassServiceImpl.updateById(testclass));
  }

  /**
   * 修改-传入修改的数据testclass
   * @param testclass testclass
   * @return XfR
   */
  @PatchMapping("/testclasss/{id}")
  public XfR patchUpdate(@RequestBody Testclass testclass,@PathVariable Long id) {
      Testclass uptestclass = testclassServiceImpl.getById(id);
      if(uptestclass != null){
        uptestclass = ObjectCopyUtils.copyProperties(testclass,uptestclass,true);
      }
      return XfR.ok(testclassServiceImpl.updateById(uptestclass));
  }

  /**
   * 通过id删除testclass
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testclasss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testclassServiceImpl.removeById(id));
  }

  @PostMapping("/testclasss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testclass");
     params.put("request", condition);

     return XfR.ok(testclassServiceImpl.querys(params));
  }

}
