package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testdongtai040401;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestdongtai040401Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testdongtai040401前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Testdongtai040401Controller {

  @Autowired
  private ITestdongtai040401Service testdongtai040401ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdongtai040401 testdongtai040401
   * @return
   */
  @GetMapping("/testdongtai040401s" )
  public XfR getTestdongtai040401s(XfPage page, Testdongtai040401 testdongtai040401) {
    return XfR.ok(testdongtai040401ServiceImpl.page(page, Wrappers.query(testdongtai040401)));
  }

  /**
   * 通过id查询testdongtai040401
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdongtai040401s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdongtai040401ServiceImpl.getById(id));
  }

  /**
   * 新增testdongtai040401
   * @param testdongtai040401 testdongtai040401
   * @return XfR
   */
  @PostMapping("/testdongtai040401s")
  public XfR save(@RequestBody Testdongtai040401 testdongtai040401) {
     return XfR.ok(testdongtai040401ServiceImpl.save(testdongtai040401));
  }

  /**
   * 修改-传入修改后的全部数据testdongtai040401
   * @param testdongtai040401 testdongtai040401
   * @return XfR
   */
  @PutMapping("/testdongtai040401s/{id}")
  public XfR putUpdate(@RequestBody Testdongtai040401 testdongtai040401,@PathVariable Long id) {
      testdongtai040401.setId(id);
      return XfR.ok(testdongtai040401ServiceImpl.updateById(testdongtai040401));
  }

  /**
   * 修改-传入修改的数据testdongtai040401
   * @param testdongtai040401 testdongtai040401
   * @return XfR
   */
  @PatchMapping("/testdongtai040401s/{id}")
  public XfR patchUpdate(@RequestBody Testdongtai040401 testdongtai040401,@PathVariable Long id) {
      Testdongtai040401 uptestdongtai040401 = testdongtai040401ServiceImpl.getById(id);
      if(uptestdongtai040401 != null){
        uptestdongtai040401 = ObjectCopyUtils.copyProperties(testdongtai040401,uptestdongtai040401,true);
      }
      return XfR.ok(testdongtai040401ServiceImpl.updateById(uptestdongtai040401));
  }

  /**
   * 通过id删除testdongtai040401
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdongtai040401s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdongtai040401ServiceImpl.removeById(id));
  }

  @PostMapping("/testdongtai040401s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdongtai040401");
     params.put("request", condition);

     return XfR.ok(testdongtai040401ServiceImpl.querys(params));
  }

}
