package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testflow;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestflowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestflowController {

  @Autowired
  private ITestflowService testflowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testflow ${table.comment}
   * @return
   */
  @GetMapping("/testflows" )
  public XfR getTestflows(XfPage page, Testflow testflow) {
    return XfR.ok(testflowServiceImpl.page(page, Wrappers.query(testflow)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testflows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testflowServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testflow ${table.comment}
   * @return XfR
   */
  @PostMapping("/testflows")
  public XfR save(@RequestBody Testflow testflow) {
     return XfR.ok(testflowServiceImpl.save(testflow));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testflow ${table.comment}
   * @return XfR
   */
  @PutMapping("/testflows/{id}")
  public XfR putUpdate(@RequestBody Testflow testflow,@PathVariable Long id) {
      testflow.setId(id);
      return XfR.ok(testflowServiceImpl.updateById(testflow));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testflow ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testflows/{id}")
  public XfR patchUpdate(@RequestBody Testflow testflow,@PathVariable Long id) {
      Testflow uptestflow = testflowServiceImpl.getById(id);
      if(uptestflow != null){
        uptestflow = ObjectCopyUtils.copyProperties(testflow,uptestflow,true);
      }
      return XfR.ok(testflowServiceImpl.updateById(uptestflow));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testflows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testflowServiceImpl.removeById(id));
  }

  @PostMapping("/testflows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testflow");
     params.put("request", condition);

     return XfR.ok(testflowServiceImpl.querys(params));
  }

}
