package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testjine0310;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestjine0310Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testjine0310前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Testjine0310Controller {

  @Autowired
  private ITestjine0310Service testjine0310ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testjine0310 testjine0310
   * @return
   */
  @GetMapping("/testjine0310s" )
  public XfR getTestjine0310s(XfPage page, Testjine0310 testjine0310) {
    return XfR.ok(testjine0310ServiceImpl.page(page, Wrappers.query(testjine0310)));
  }

  /**
   * 通过id查询testjine0310
   * @param  id
   * @return XfR
   */
  @GetMapping("/testjine0310s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testjine0310ServiceImpl.getById(id));
  }

  /**
   * 新增testjine0310
   * @param testjine0310 testjine0310
   * @return XfR
   */
  @PostMapping("/testjine0310s")
  public XfR save(@RequestBody Testjine0310 testjine0310) {
     return XfR.ok(testjine0310ServiceImpl.save(testjine0310));
  }

  /**
   * 修改-传入修改后的全部数据testjine0310
   * @param testjine0310 testjine0310
   * @return XfR
   */
  @PutMapping("/testjine0310s/{id}")
  public XfR putUpdate(@RequestBody Testjine0310 testjine0310,@PathVariable Long id) {
      testjine0310.setId(id);
      return XfR.ok(testjine0310ServiceImpl.updateById(testjine0310));
  }

  /**
   * 修改-传入修改的数据testjine0310
   * @param testjine0310 testjine0310
   * @return XfR
   */
  @PatchMapping("/testjine0310s/{id}")
  public XfR patchUpdate(@RequestBody Testjine0310 testjine0310,@PathVariable Long id) {
      Testjine0310 uptestjine0310 = testjine0310ServiceImpl.getById(id);
      if(uptestjine0310 != null){
        uptestjine0310 = ObjectCopyUtils.copyProperties(testjine0310,uptestjine0310,true);
      }
      return XfR.ok(testjine0310ServiceImpl.updateById(uptestjine0310));
  }

  /**
   * 通过id删除testjine0310
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testjine0310s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testjine0310ServiceImpl.removeById(id));
  }

  @PostMapping("/testjine0310s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testjine0310");
     params.put("request", condition);

     return XfR.ok(testjine0310ServiceImpl.querys(params));
  }

}
