package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testmeiju;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestmeijuService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestmeijuController {

  @Autowired
  private ITestmeijuService testmeijuServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testmeiju ${table.comment}
   * @return
   */
  @GetMapping("/testmeijus" )
  public XfR getTestmeijus(XfPage page, Testmeiju testmeiju) {
    return XfR.ok(testmeijuServiceImpl.page(page, Wrappers.query(testmeiju)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testmeijus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testmeijuServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testmeiju ${table.comment}
   * @return XfR
   */
  @PostMapping("/testmeijus")
  public XfR save(@RequestBody Testmeiju testmeiju) {
     return XfR.ok(testmeijuServiceImpl.save(testmeiju));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testmeiju ${table.comment}
   * @return XfR
   */
  @PutMapping("/testmeijus/{id}")
  public XfR putUpdate(@RequestBody Testmeiju testmeiju,@PathVariable Long id) {
      testmeiju.setId(id);
      return XfR.ok(testmeijuServiceImpl.updateById(testmeiju));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testmeiju ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testmeijus/{id}")
  public XfR patchUpdate(@RequestBody Testmeiju testmeiju,@PathVariable Long id) {
      Testmeiju uptestmeiju = testmeijuServiceImpl.getById(id);
      if(uptestmeiju != null){
        uptestmeiju = ObjectCopyUtils.copyProperties(testmeiju,uptestmeiju,true);
      }
      return XfR.ok(testmeijuServiceImpl.updateById(uptestmeiju));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testmeijus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testmeijuServiceImpl.removeById(id));
  }

  @PostMapping("/testmeijus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testmeiju");
     params.put("request", condition);

     return XfR.ok(testmeijuServiceImpl.querys(params));
  }

}
