package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testmsg;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestmsgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testmsg前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestmsgController {

  @Autowired
  private ITestmsgService testmsgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testmsg testmsg
   * @return
   */
  @GetMapping("/testmsgs" )
  public XfR getTestmsgs(XfPage page, Testmsg testmsg) {
    return XfR.ok(testmsgServiceImpl.page(page, Wrappers.query(testmsg)));
  }

  /**
   * 通过id查询testmsg
   * @param  id
   * @return XfR
   */
  @GetMapping("/testmsgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testmsgServiceImpl.getById(id));
  }

  /**
   * 新增testmsg
   * @param testmsg testmsg
   * @return XfR
   */
  @PostMapping("/testmsgs")
  public XfR save(@RequestBody Testmsg testmsg) {
     return XfR.ok(testmsgServiceImpl.save(testmsg));
  }

  /**
   * 修改-传入修改后的全部数据testmsg
   * @param testmsg testmsg
   * @return XfR
   */
  @PutMapping("/testmsgs/{id}")
  public XfR putUpdate(@RequestBody Testmsg testmsg,@PathVariable Long id) {
      testmsg.setId(id);
      return XfR.ok(testmsgServiceImpl.updateById(testmsg));
  }

  /**
   * 修改-传入修改的数据testmsg
   * @param testmsg testmsg
   * @return XfR
   */
  @PatchMapping("/testmsgs/{id}")
  public XfR patchUpdate(@RequestBody Testmsg testmsg,@PathVariable Long id) {
      Testmsg uptestmsg = testmsgServiceImpl.getById(id);
      if(uptestmsg != null){
        uptestmsg = ObjectCopyUtils.copyProperties(testmsg,uptestmsg,true);
      }
      return XfR.ok(testmsgServiceImpl.updateById(uptestmsg));
  }

  /**
   * 通过id删除testmsg
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testmsgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testmsgServiceImpl.removeById(id));
  }

  @PostMapping("/testmsgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testmsg");
     params.put("request", condition);

     return XfR.ok(testmsgServiceImpl.querys(params));
  }

}
