package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testnianji;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestnianjiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testnianji前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestnianjiController {

  @Autowired
  private ITestnianjiService testnianjiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testnianji testnianji
   * @return
   */
  @GetMapping("/testnianjis" )
  public XfR getTestnianjis(XfPage page, Testnianji testnianji) {
    return XfR.ok(testnianjiServiceImpl.page(page, Wrappers.query(testnianji)));
  }

  /**
   * 通过id查询testnianji
   * @param  id
   * @return XfR
   */
  @GetMapping("/testnianjis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testnianjiServiceImpl.getById(id));
  }

  /**
   * 新增testnianji
   * @param testnianji testnianji
   * @return XfR
   */
  @PostMapping("/testnianjis")
  public XfR save(@RequestBody Testnianji testnianji) {
     return XfR.ok(testnianjiServiceImpl.save(testnianji));
  }

  /**
   * 修改-传入修改后的全部数据testnianji
   * @param testnianji testnianji
   * @return XfR
   */
  @PutMapping("/testnianjis/{id}")
  public XfR putUpdate(@RequestBody Testnianji testnianji,@PathVariable Long id) {
      testnianji.setId(id);
      return XfR.ok(testnianjiServiceImpl.updateById(testnianji));
  }

  /**
   * 修改-传入修改的数据testnianji
   * @param testnianji testnianji
   * @return XfR
   */
  @PatchMapping("/testnianjis/{id}")
  public XfR patchUpdate(@RequestBody Testnianji testnianji,@PathVariable Long id) {
      Testnianji uptestnianji = testnianjiServiceImpl.getById(id);
      if(uptestnianji != null){
        uptestnianji = ObjectCopyUtils.copyProperties(testnianji,uptestnianji,true);
      }
      return XfR.ok(testnianjiServiceImpl.updateById(uptestnianji));
  }

  /**
   * 通过id删除testnianji
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testnianjis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testnianjiServiceImpl.removeById(id));
  }

  @PostMapping("/testnianjis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testnianji");
     params.put("request", condition);

     return XfR.ok(testnianjiServiceImpl.querys(params));
  }

}
