package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testzhu0120;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestzhu0120Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testzhu0120前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Testzhu0120Controller {

  @Autowired
  private ITestzhu0120Service testzhu0120ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzhu0120 testzhu0120
   * @return
   */
  @GetMapping("/testzhu0120s" )
  public XfR getTestzhu0120s(XfPage page, Testzhu0120 testzhu0120) {
    return XfR.ok(testzhu0120ServiceImpl.page(page, Wrappers.query(testzhu0120)));
  }

  /**
   * 通过id查询testzhu0120
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzhu0120s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzhu0120ServiceImpl.getById(id));
  }

  /**
   * 新增testzhu0120
   * @param testzhu0120 testzhu0120
   * @return XfR
   */
  @PostMapping("/testzhu0120s")
  public XfR save(@RequestBody Testzhu0120 testzhu0120) {
     return XfR.ok(testzhu0120ServiceImpl.save(testzhu0120));
  }

  /**
   * 修改-传入修改后的全部数据testzhu0120
   * @param testzhu0120 testzhu0120
   * @return XfR
   */
  @PutMapping("/testzhu0120s/{id}")
  public XfR putUpdate(@RequestBody Testzhu0120 testzhu0120,@PathVariable Long id) {
      testzhu0120.setId(id);
      return XfR.ok(testzhu0120ServiceImpl.updateById(testzhu0120));
  }

  /**
   * 修改-传入修改的数据testzhu0120
   * @param testzhu0120 testzhu0120
   * @return XfR
   */
  @PatchMapping("/testzhu0120s/{id}")
  public XfR patchUpdate(@RequestBody Testzhu0120 testzhu0120,@PathVariable Long id) {
      Testzhu0120 uptestzhu0120 = testzhu0120ServiceImpl.getById(id);
      if(uptestzhu0120 != null){
        uptestzhu0120 = ObjectCopyUtils.copyProperties(testzhu0120,uptestzhu0120,true);
      }
      return XfR.ok(testzhu0120ServiceImpl.updateById(uptestzhu0120));
  }

  /**
   * 通过id删除testzhu0120
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzhu0120s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzhu0120ServiceImpl.removeById(id));
  }

  @PostMapping("/testzhu0120s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzhu0120");
     params.put("request", condition);

     return XfR.ok(testzhu0120ServiceImpl.querys(params));
  }

}
