package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testzmy;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestzmyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testzmy前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class TestzmyController {

  @Autowired
  private ITestzmyService testzmyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzmy testzmy
   * @return
   */
  @GetMapping("/testzmys" )
  public XfR getTestzmys(XfPage page, Testzmy testzmy) {
    return XfR.ok(testzmyServiceImpl.page(page, Wrappers.query(testzmy)));
  }

  /**
   * 通过id查询testzmy
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzmys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzmyServiceImpl.getById(id));
  }

  /**
   * 新增testzmy
   * @param testzmy testzmy
   * @return XfR
   */
  @PostMapping("/testzmys")
  public XfR save(@RequestBody Testzmy testzmy) {
     return XfR.ok(testzmyServiceImpl.save(testzmy));
  }

  /**
   * 修改-传入修改后的全部数据testzmy
   * @param testzmy testzmy
   * @return XfR
   */
  @PutMapping("/testzmys/{id}")
  public XfR putUpdate(@RequestBody Testzmy testzmy,@PathVariable Long id) {
      testzmy.setId(id);
      return XfR.ok(testzmyServiceImpl.updateById(testzmy));
  }

  /**
   * 修改-传入修改的数据testzmy
   * @param testzmy testzmy
   * @return XfR
   */
  @PatchMapping("/testzmys/{id}")
  public XfR patchUpdate(@RequestBody Testzmy testzmy,@PathVariable Long id) {
      Testzmy uptestzmy = testzmyServiceImpl.getById(id);
      if(uptestzmy != null){
        uptestzmy = ObjectCopyUtils.copyProperties(testzmy,uptestzmy,true);
      }
      return XfR.ok(testzmyServiceImpl.updateById(uptestzmy));
  }

  /**
   * 通过id删除testzmy
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzmys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzmyServiceImpl.removeById(id));
  }

  @PostMapping("/testzmys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzmy");
     params.put("request", condition);

     return XfR.ok(testzmyServiceImpl.querys(params));
  }

}
