package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Testzzbh0301;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.ITestzzbh0301Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * testzzbh0301前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Testzzbh0301Controller {

  @Autowired
  private ITestzzbh0301Service testzzbh0301ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testzzbh0301 testzzbh0301
   * @return
   */
  @GetMapping("/testzzbh0301s" )
  public XfR getTestzzbh0301s(XfPage page, Testzzbh0301 testzzbh0301) {
    return XfR.ok(testzzbh0301ServiceImpl.page(page, Wrappers.query(testzzbh0301)));
  }

  /**
   * 通过id查询testzzbh0301
   * @param  id
   * @return XfR
   */
  @GetMapping("/testzzbh0301s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testzzbh0301ServiceImpl.getById(id));
  }

  /**
   * 新增testzzbh0301
   * @param testzzbh0301 testzzbh0301
   * @return XfR
   */
  @PostMapping("/testzzbh0301s")
  public XfR save(@RequestBody Testzzbh0301 testzzbh0301) {
     return XfR.ok(testzzbh0301ServiceImpl.save(testzzbh0301));
  }

  /**
   * 修改-传入修改后的全部数据testzzbh0301
   * @param testzzbh0301 testzzbh0301
   * @return XfR
   */
  @PutMapping("/testzzbh0301s/{id}")
  public XfR putUpdate(@RequestBody Testzzbh0301 testzzbh0301,@PathVariable Long id) {
      testzzbh0301.setId(id);
      return XfR.ok(testzzbh0301ServiceImpl.updateById(testzzbh0301));
  }

  /**
   * 修改-传入修改的数据testzzbh0301
   * @param testzzbh0301 testzzbh0301
   * @return XfR
   */
  @PatchMapping("/testzzbh0301s/{id}")
  public XfR patchUpdate(@RequestBody Testzzbh0301 testzzbh0301,@PathVariable Long id) {
      Testzzbh0301 uptestzzbh0301 = testzzbh0301ServiceImpl.getById(id);
      if(uptestzzbh0301 != null){
        uptestzzbh0301 = ObjectCopyUtils.copyProperties(testzzbh0301,uptestzzbh0301,true);
      }
      return XfR.ok(testzzbh0301ServiceImpl.updateById(uptestzzbh0301));
  }

  /**
   * 通过id删除testzzbh0301
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testzzbh0301s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testzzbh0301ServiceImpl.removeById(id));
  }

  @PostMapping("/testzzbh0301s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testzzbh0301");
     params.put("request", condition);

     return XfR.ok(testzzbh0301ServiceImpl.querys(params));
  }

}
