package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ydd033101;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IYdd033101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ydd前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ydd033101Controller {

  @Autowired
  private IYdd033101Service ydd033101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ydd033101 ydd
   * @return
   */
  @GetMapping("/ydd033101s" )
  public XfR getYdd033101s(XfPage page, Ydd033101 ydd033101) {
    return XfR.ok(ydd033101ServiceImpl.page(page, Wrappers.query(ydd033101)));
  }

  /**
   * 通过id查询ydd
   * @param  id
   * @return XfR
   */
  @GetMapping("/ydd033101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ydd033101ServiceImpl.getById(id));
  }

  /**
   * 新增ydd
   * @param ydd033101 ydd
   * @return XfR
   */
  @PostMapping("/ydd033101s")
  public XfR save(@RequestBody Ydd033101 ydd033101) {
     return XfR.ok(ydd033101ServiceImpl.save(ydd033101));
  }

  /**
   * 修改-传入修改后的全部数据ydd
   * @param ydd033101 ydd
   * @return XfR
   */
  @PutMapping("/ydd033101s/{id}")
  public XfR putUpdate(@RequestBody Ydd033101 ydd033101,@PathVariable Long id) {
      ydd033101.setId(id);
      return XfR.ok(ydd033101ServiceImpl.updateById(ydd033101));
  }

  /**
   * 修改-传入修改的数据ydd
   * @param ydd033101 ydd
   * @return XfR
   */
  @PatchMapping("/ydd033101s/{id}")
  public XfR patchUpdate(@RequestBody Ydd033101 ydd033101,@PathVariable Long id) {
      Ydd033101 upydd033101 = ydd033101ServiceImpl.getById(id);
      if(upydd033101 != null){
        upydd033101 = ObjectCopyUtils.copyProperties(ydd033101,upydd033101,true);
      }
      return XfR.ok(ydd033101ServiceImpl.updateById(upydd033101));
  }

  /**
   * 通过id删除ydd
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ydd033101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ydd033101ServiceImpl.removeById(id));
  }

  @PostMapping("/ydd033101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ydd033101");
     params.put("request", condition);

     return XfR.ok(ydd033101ServiceImpl.querys(params));
  }

}
