package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Zhuobject;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IZhuobjectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 主对象1230前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class ZhuobjectController {

  @Autowired
  private IZhuobjectService zhuobjectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zhuobject 主对象1230
   * @return
   */
  @GetMapping("/zhuobjects" )
  public XfR getZhuobjects(XfPage page, Zhuobject zhuobject) {
    return XfR.ok(zhuobjectServiceImpl.page(page, Wrappers.query(zhuobject)));
  }

  /**
   * 通过id查询主对象1230
   * @param  id
   * @return XfR
   */
  @GetMapping("/zhuobjects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zhuobjectServiceImpl.getById(id));
  }

  /**
   * 新增主对象1230
   * @param zhuobject 主对象1230
   * @return XfR
   */
  @PostMapping("/zhuobjects")
  public XfR save(@RequestBody Zhuobject zhuobject) {
     return XfR.ok(zhuobjectServiceImpl.save(zhuobject));
  }

  /**
   * 修改-传入修改后的全部数据主对象1230
   * @param zhuobject 主对象1230
   * @return XfR
   */
  @PutMapping("/zhuobjects/{id}")
  public XfR putUpdate(@RequestBody Zhuobject zhuobject,@PathVariable Long id) {
      zhuobject.setId(id);
      return XfR.ok(zhuobjectServiceImpl.updateById(zhuobject));
  }

  /**
   * 修改-传入修改的数据主对象1230
   * @param zhuobject 主对象1230
   * @return XfR
   */
  @PatchMapping("/zhuobjects/{id}")
  public XfR patchUpdate(@RequestBody Zhuobject zhuobject,@PathVariable Long id) {
      Zhuobject upzhuobject = zhuobjectServiceImpl.getById(id);
      if(upzhuobject != null){
        upzhuobject = ObjectCopyUtils.copyProperties(zhuobject,upzhuobject,true);
      }
      return XfR.ok(zhuobjectServiceImpl.updateById(upzhuobject));
  }

  /**
   * 通过id删除主对象1230
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zhuobjects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zhuobjectServiceImpl.removeById(id));
  }

  @PostMapping("/zhuobjects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zhuobject");
     params.put("request", condition);

     return XfR.ok(zhuobjectServiceImpl.querys(params));
  }

}
