package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Zichan;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IZichanService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zichan前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class ZichanController {

  @Autowired
  private IZichanService zichanServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zichan zichan
   * @return
   */
  @GetMapping("/zichans" )
  public XfR getZichans(XfPage page, Zichan zichan) {
    return XfR.ok(zichanServiceImpl.page(page, Wrappers.query(zichan)));
  }

  /**
   * 通过id查询zichan
   * @param  id
   * @return XfR
   */
  @GetMapping("/zichans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zichanServiceImpl.getById(id));
  }

  /**
   * 新增zichan
   * @param zichan zichan
   * @return XfR
   */
  @PostMapping("/zichans")
  public XfR save(@RequestBody Zichan zichan) {
     return XfR.ok(zichanServiceImpl.save(zichan));
  }

  /**
   * 修改-传入修改后的全部数据zichan
   * @param zichan zichan
   * @return XfR
   */
  @PutMapping("/zichans/{id}")
  public XfR putUpdate(@RequestBody Zichan zichan,@PathVariable Long id) {
      zichan.setId(id);
      return XfR.ok(zichanServiceImpl.updateById(zichan));
  }

  /**
   * 修改-传入修改的数据zichan
   * @param zichan zichan
   * @return XfR
   */
  @PatchMapping("/zichans/{id}")
  public XfR patchUpdate(@RequestBody Zichan zichan,@PathVariable Long id) {
      Zichan upzichan = zichanServiceImpl.getById(id);
      if(upzichan != null){
        upzichan = ObjectCopyUtils.copyProperties(zichan,upzichan,true);
      }
      return XfR.ok(zichanServiceImpl.updateById(upzichan));
  }

  /**
   * 通过id删除zichan
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zichans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zichanServiceImpl.removeById(id));
  }

  @PostMapping("/zichans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zichan");
     params.put("request", condition);

     return XfR.ok(zichanServiceImpl.querys(params));
  }

}
