package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Zilei;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IZileiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 子类前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class ZileiController {

  @Autowired
  private IZileiService zileiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei 子类
   * @return
   */
  @GetMapping("/zileis" )
  public XfR getZileis(XfPage page, Zilei zilei) {
    return XfR.ok(zileiServiceImpl.page(page, Wrappers.query(zilei)));
  }

  /**
   * 通过id查询子类
   * @param  id
   * @return XfR
   */
  @GetMapping("/zileis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zileiServiceImpl.getById(id));
  }

  /**
   * 新增子类
   * @param zilei 子类
   * @return XfR
   */
  @PostMapping("/zileis")
  public XfR save(@RequestBody Zilei zilei) {
     return XfR.ok(zileiServiceImpl.save(zilei));
  }

  /**
   * 修改-传入修改后的全部数据子类
   * @param zilei 子类
   * @return XfR
   */
  @PutMapping("/zileis/{id}")
  public XfR putUpdate(@RequestBody Zilei zilei,@PathVariable Long id) {
      zilei.setId(id);
      return XfR.ok(zileiServiceImpl.updateById(zilei));
  }

  /**
   * 修改-传入修改的数据子类
   * @param zilei 子类
   * @return XfR
   */
  @PatchMapping("/zileis/{id}")
  public XfR patchUpdate(@RequestBody Zilei zilei,@PathVariable Long id) {
      Zilei upzilei = zileiServiceImpl.getById(id);
      if(upzilei != null){
        upzilei = ObjectCopyUtils.copyProperties(zilei,upzilei,true);
      }
      return XfR.ok(zileiServiceImpl.updateById(upzilei));
  }

  /**
   * 通过id删除子类
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zileis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zileiServiceImpl.removeById(id));
  }

  @PostMapping("/zileis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei");
     params.put("request", condition);

     return XfR.ok(zileiServiceImpl.querys(params));
  }

}
