package com.xforceplus.ultraman.app.ultramanbocp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 猫科
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum Cat {

    FLOWER("flower", "花猫"),
    BLACK("black", "黑猫"),
    BLUE("blue", "蓝猫"),
    RED("red", "红猫"),
    BROWN("brown", "棕猫"),
    WHITE("white", "白猫");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Cat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Cat fromCode(String code){
        switch(code) {
            case "flower":
                return FLOWER;
            case "black":
                return BLACK;
            case "blue":
                return BLUE;
            case "red":
                return RED;
            case "brown":
                return BROWN;
            case "white":
                return WHITE;
            default:
                return null;
        }
    }
}
