package com.xforceplus.ultraman.app.ultramanflows.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * job_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-27
 */
public enum JobStatus {

    _1("1", "运行中"),
    _2("2", "已完成"),
    _0("0", "失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JobStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JobStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
