package com.xforceplus.ultraman.app.ultramanoamanager.controller;


/**
 * 应用环境信息feign客户端
 *
 * @author ultraman
 * @date 2024-04-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ultramanoamanager.entity.AppDevopsEnvEx;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-oa-manager")
public interface AppDevopsEnvExFeignApi {

  /**
   * 通过id查询应用环境信息
   * @param  id
   * @return R
   */
  @GetMapping("/appDevopsEnvEx/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用环境信息
   * @param appDevopsEnvEx 应用环境信息
   * @return R
   */
  @PostMapping("/appDevopsEnvEx/add")
  public R save(@RequestBody AppDevopsEnvEx appDevopsEnvEx);

  /**
   * 修改应用环境信息
   * @param appDevopsEnvEx 应用环境信息
   * @return R
   */
  @PostMapping("/appDevopsEnvEx/update")
  public R updateById(@RequestBody AppDevopsEnvEx appDevopsEnvEx);

  /**
   * 通过id删除应用环境信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/appDevopsEnvEx/del/{id}" )
  public R removeById(@PathVariable Long id);

}