package com.xforceplus.ultraman.app.ultramanoamanager.controller;


/**
 * 应用信息feign客户端
 *
 * @author ultraman
 * @date 2023-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ultramanoamanager.entity.AppInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-oa-manager")
public interface AppInfoFeignApi {

  /**
   * 通过id查询应用信息
   * @param  id
   * @return R
   */
  @GetMapping("/appInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用信息
   * @param appInfo 应用信息
   * @return R
   */
  @PostMapping("/appInfo/add")
  public R save(@RequestBody AppInfo appInfo);

  /**
   * 修改应用信息
   * @param appInfo 应用信息
   * @return R
   */
  @PostMapping("/appInfo/update")
  public R updateById(@RequestBody AppInfo appInfo);

  /**
   * 通过id删除应用信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/appInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}