package com.xforceplus.ultraman.app.ultramanoamanager.controller;


/**
 * 环境信息feign客户端
 *
 * @author ultraman
 * @date 2023-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.ultramanoamanager.entity.EnvInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-oa-manager")
public interface EnvInfoFeignApi {

  /**
   * 通过id查询环境信息
   * @param  id
   * @return R
   */
  @GetMapping("/envInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增环境信息
   * @param envInfo 环境信息
   * @return R
   */
  @PostMapping("/envInfo/add")
  public R save(@RequestBody EnvInfo envInfo);

  /**
   * 修改环境信息
   * @param envInfo 环境信息
   * @return R
   */
  @PostMapping("/envInfo/update")
  public R updateById(@RequestBody EnvInfo envInfo);

  /**
   * 通过id删除环境信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/envInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}