package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * app_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum AppType {

    INTE_CLOUD("inte-cloud", "集成二开-云端"),
    NEW_CLOUD("new-cloud", "OQS（2.0）"),
    CLOUD("cloud", "云端"),
    LOCAL("local", "属地"),
    INTE_LOCAL("inte-local", "集成二开-属地"),
    MULTI_TENANT_CLOUD("multi-tenant-cloud", "云端(支持租户定制应用)"),
    MULTI_TENANT_NEW_CLOUD("multi-tenant-new-cloud", "云端2.0(支持租户定制应用)");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AppType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppType fromCode(String code){
        switch(code) {
            case "inte-cloud":
                return INTE_CLOUD;
            case "new-cloud":
                return NEW_CLOUD;
            case "cloud":
                return CLOUD;
            case "local":
                return LOCAL;
            case "inte-local":
                return INTE_LOCAL;
            case "multi-tenant-cloud":
                return MULTI_TENANT_CLOUD;
            case "multi-tenant-new-cloud":
                return MULTI_TENANT_NEW_CLOUD;
            default:
                return null;
        }
    }
}
