package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * atomic_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum AtomicStatus {

    _0("0", "成功"),
    _1("1", "奥特曼创建应用失败"),
    _2("2", "猪齿鱼创建应用失败"),
    _3("3", "bitbucket创建应用失败"),
    _4("4", "gitlab git clone失败"),
    _5("5", "修改pom文件失败"),
    _6("6", "修改yml失败"),
    _7("7", "bitbucket git clone失败"),
    _8("8", "bitbucket git push失败"),
    _9("9", "kubsphere创建应用失败"),
    _10("10", "刷新路由失败"),
    _11("11", "copy file to bitbucket 失败"),
    _12("12", "chart修改失败"),
    _13("13", "mysql创建失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AtomicStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AtomicStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            default:
                return null;
        }
    }
}
