package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cluster_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum ClusterType {

    PSCC_NORMAL("pscc_normal", "交付测试集群"),
    ALIYUN_NORMAL("aliyun_normal", "研发测试集群"),
    PSCC_PROD("pscc_prod", "交付生产集群"),
    ALIYUN_PROD("aliyun_prod", "研发生产集群");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ClusterType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ClusterType fromCode(String code){
        switch(code) {
            case "pscc_normal":
                return PSCC_NORMAL;
            case "aliyun_normal":
                return ALIYUN_NORMAL;
            case "pscc_prod":
                return PSCC_PROD;
            case "aliyun_prod":
                return ALIYUN_PROD;
            default:
                return null;
        }
    }
}
