package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * custom_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum CustomType {

    STANDARD("standard", "标准应用"),
    TENANT("tenant", "标准应用租户定制"),
    CUSTOM("custom", "定制应用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CustomType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomType fromCode(String code){
        switch(code) {
            case "standard":
                return STANDARD;
            case "tenant":
                return TENANT;
            case "custom":
                return CUSTOM;
            default:
                return null;
        }
    }
}
