package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * db_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum DbType {

    SHARE("share", "共享"),
    INDEPENDENT("independent", "独立");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DbType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DbType fromCode(String code){
        switch(code) {
            case "share":
                return SHARE;
            case "independent":
                return INDEPENDENT;
            default:
                return null;
        }
    }
}
