package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * handler_stage
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum HandlerStage {

    _10("10", "应用创建阶段"),
    _40("40", "后端代码初始化阶段"),
    _60("60", "代码仓库初始化阶段"),
    _80("80", "KS初始化阶段"),
    _100("100", "网关配置阶段"),
    _120("120", "数据库初始化阶段"),
    _0("0", "处理完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandlerStage(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandlerStage fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "40":
                return _40;
            case "60":
                return _60;
            case "80":
                return _80;
            case "100":
                return _100;
            case "120":
                return _120;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
