package com.xforceplus.ultraman.app.ultramanoamanager.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum Status {

    _0("0", "草稿"),
    _1("1", "待审批"),
    _2("2", "驳回"),
    _3("3", "通过");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
