package com.xforceplus.ultraman.app.ultramanoamanager.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 应用信息
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AppInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 应用编码
   */
  @TableField("appCode")
  private String appCode;

  /**
   * 应用Id
   */
  @TableField("appId")
  private Long appId;

  /**
   * 应用名称
   */
  @TableField("appName")
  private String appName;

  /**
   * 应用开发者
   */
  @TableField("appDeveloper")
  private String appDeveloper;

  /**
   * 应用类型
   */
  @TableField("appType")
  private String appType;

  /**
   * 申请状态
   */
  private String status;

  /**
   * 自动化状态
   */
  @TableField("atomicStatus")
  private String atomicStatus;

  /**
   * 备注
   */
  private String remark;

  /**
   * 邮箱
   */
  private String mail;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * git仓库地址
   */
  @TableField("gitRepository")
  private String gitRepository;

  /**
   * ci地址
   */
  @TableField("ciLink")
  private String ciLink;

  /**
   * ip地址
   */
  private String ip;

  /**
   * 属地脚本命令
   */
  private String command;

  /**
   * skipEnvCheck
   */
  @TableField("skipEnvCheck")
  private String skipEnvCheck;

  /**
   * 前端脚手架初始化状态
   */
  @TableField("forntTemStatus")
  private String forntTemStatus;

  /**
   * 集成平台项目id
   */
  @TableField("janusProjectId")
  private String janusProjectId;

  /**
   * 数据库资源类型
   */
  @TableField("dbType")
  private String dbType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("appCode", appCode);
      map.put("appId", appId);
      map.put("appName", appName);
      map.put("appDeveloper", appDeveloper);
      map.put("appType", appType);
      map.put("status", status);
      map.put("atomicStatus", atomicStatus);
      map.put("remark", remark);
      map.put("mail", mail);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("gitRepository", gitRepository);
      map.put("ciLink", ciLink);
      map.put("ip", ip);
      map.put("command", command);
      map.put("skipEnvCheck", skipEnvCheck);
      map.put("forntTemStatus", forntTemStatus);
      map.put("janusProjectId", janusProjectId);
      map.put("dbType", dbType);

      return map;
  }

  public static AppInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AppInfo entity = new AppInfo();
    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("appName")) {
      Object obj = map.get("appName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appDeveloper")) {
      Object obj = map.get("appDeveloper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppDeveloper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appType")) {
      Object obj = map.get("appType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("atomicStatus")) {
      Object obj = map.get("atomicStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAtomicStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitRepository")) {
      Object obj = map.get("gitRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGitRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ciLink")) {
      Object obj = map.get("ciLink");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCiLink((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ip")) {
      Object obj = map.get("ip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("command")) {
      Object obj = map.get("command");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skipEnvCheck")) {
      Object obj = map.get("skipEnvCheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkipEnvCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("forntTemStatus")) {
      Object obj = map.get("forntTemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setForntTemStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("janusProjectId")) {
      Object obj = map.get("janusProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJanusProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbType")) {
      Object obj = map.get("dbType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDbType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAppId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("appName")) {
      Object obj = map.get("appName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("appDeveloper")) {
      Object obj = map.get("appDeveloper");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppDeveloper((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("appType")) {
      Object obj = map.get("appType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("atomicStatus")) {
      Object obj = map.get("atomicStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAtomicStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gitRepository")) {
      Object obj = map.get("gitRepository");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGitRepository((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ciLink")) {
      Object obj = map.get("ciLink");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCiLink((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ip")) {
      Object obj = map.get("ip");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("command")) {
      Object obj = map.get("command");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCommand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("skipEnvCheck")) {
      Object obj = map.get("skipEnvCheck");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkipEnvCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("forntTemStatus")) {
      Object obj = map.get("forntTemStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setForntTemStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("janusProjectId")) {
      Object obj = map.get("janusProjectId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJanusProjectId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dbType")) {
      Object obj = map.get("dbType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDbType((String)obj);
        }
      } else {
      }
    }
  }
}
