package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * app_env_resources
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum AppEnvResources {

    KS_SERVICE_NAMESPACE_TRUE("ksServiceNamespace-true", "有集群服务空间"),
    KS_FRONTEND_NAMESPACE_TRUE("ksFrontendNamespace-true", "有集群前端二开空间"),
    KS_FRONTEND_NAMESPACE_FALSE("ksFrontendNamespace-false", "无集群前端二开空间"),
    KS_SERVICE_APP_TRUE("ksServiceApp-true", "有集群应用"),
    KS_SERVICE_APP_FALSE("ksServiceApp-false", "无集群应用"),
    KS_FRONTEND_APP_TRUE("ksFrontendApp-true", "有集群前端二开"),
    KS_FRONTEND_APP_FALSE("ksFrontendApp-false", "无集群前端二开"),
    KS_FRONTEND_INGRESS_TRUE("ksFrontendIngress-true", "有集群路由"),
    KS_FRONTEND_INGRESS_FALSE("ksFrontendIngress-false", "无集群路由"),
    FRONTEND_APP_SETTING_TRUE("frontendAppSetting-true", "有前端应用"),
    FRONTEND_APP_SETTING_FALSE("frontendAppSetting-false", "无前端应用"),
    FRONTEND_MENU_TRUE("frontendMenu-true", "有前端菜单"),
    FRONTEND_MENU_FALSE("frontendMenu-false", "无前端菜单"),
    SERVICE_DNS_TRUE("serviceDns-true", "有服务DNS"),
    SERVICE_DNS_FALSE("serviceDns-false", "无服务DNS"),
    FRONTEND_DNS_TRUE("frontendDns-true", "有前端DNS"),
    FRONTEND_DNS_FALSE("frontendDns-false", "无前端DNS"),
    MYSQL_TRUE("mysql-true", "有Mysql"),
    MYSQL_FALSE("mysql-false", "无Mysql"),
    GATEWAY_ROUTE_TRUE("gatewayRoute-true", "有网关配置"),
    GATEWAY_ROUTE_FALSE("gatewayRoute-false", "无网关配置"),
    SERVICE_RUNNING_TRUE("serviceRunning-true", "服务运行中"),
    SERVICE_RUNNING_FALSE("serviceRunning-false", "服务未运行"),
    FRONTEND_RUNNING_TRUE("frontendRunning-true", "前端运行中"),
    FRONTEND_RUNNING_FALSE("frontendRunning-false", "前端未运行"),
    KS_SERVICE_NAMESPACE_FALSE("ksServiceNamespace-false", "无集群服务空间");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AppEnvResources(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppEnvResources fromCode(String code) {
        return Stream.of(AppEnvResources.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
