package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * app_purpose
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum AppPurpose {

    _0("0", "交付应用"),
    _1("1", "产线应用"),
    _2("2", "属地应用"),
    _3("3", "外部应用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AppPurpose(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppPurpose fromCode(String code) {
        return Stream.of(AppPurpose.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
