package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * atomic_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum AtomicStatus {

    _0("0", "成功"),
    _1("1", "奥特曼创建应用失败"),
    _2("2", "猪齿鱼创建应用失败"),
    _3("3", "bitbucket创建应用失败"),
    _4("4", "gitlab git clone失败"),
    _5("5", "修改pom文件失败"),
    _6("6", "修改yml失败"),
    _7("7", "bitbucket git clone失败"),
    _8("8", "bitbucket git push失败"),
    _9("9", "kubsphere创建应用失败"),
    _10("10", "刷新路由失败"),
    _11("11", "copy file to bitbucket 失败"),
    _12("12", "chart修改失败"),
    _13("13", "mysql创建失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AtomicStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AtomicStatus fromCode(String code) {
        return Stream.of(AtomicStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
