package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cluster_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum ClusterType {

    ALI_CUSTOMIZE_NORMAL("ali-customize-normal", "交付测试集群"),
    ALI_DEVOPS_NORMAL("ali-devops-normal", "研发测试集群"),
    ALI_CUSTOMIZE_PROD("ali-customize-prod", "交付生产集群"),
    ALI_DEVOPS_PROD("ali-devops-prod", "研发生产集群"),
    AWS_DEVOPS_NORMAL("aws-devops-normal", "AWS测试集群");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ClusterType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ClusterType fromCode(String code) {
        return Stream.of(ClusterType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
