package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * custom_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum CustomType {

    STANDARD("standard", "标准应用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CustomType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomType fromCode(String code) {
        return Stream.of(CustomType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
