package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * db_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum DbType {

    SHARE("share", "K8S共享数据库"),
    INDEPENDENT("independent", "K8S独立数据库");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DbType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DbType fromCode(String code) {
        return Stream.of(DbType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
