package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * fornt_tem_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum ForntTemStatus {

    _0("0", "未初始化"),
    _1("1", "已初始化");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ForntTemStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ForntTemStatus fromCode(String code) {
        return Stream.of(ForntTemStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
