package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * handler_stage
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum HandlerStage {

    _10("10", "5%-应用创建阶段"),
    _40("40", "20%-后端代码模版初始化阶段"),
    _60("60", "30%-Gitlab代码库初始化阶段"),
    _80("80", "40%-KS资源初始化阶段"),
    _100("100", "50%-网关配置阶段"),
    _120("120", "60%-数据库初始化阶段"),
    _0("0", "100%-初始化完成"),
    _140("140", "70%-前端应用初始化阶段"),
    _160("160", "80%-前端代码初始化阶段"),
    _180("180", "90%-集成平台项目创建阶段"),
    _70("70", "35%-Bitbucket代码库初始化");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HandlerStage(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandlerStage fromCode(String code) {
        return Stream.of(HandlerStage.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
