package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_workspace
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public enum KsWorkspace {

    XFORCEPLUS("xforceplus", "票易通"),
    VANKE("vanke", "万科");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsWorkspace(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsWorkspace fromCode(String code) {
        return Stream.of(KsWorkspace.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
