package com.xforceplus.ultraman.app.ultramanoamanager.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * app_dev_ops_ex
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AppDevOpsEx implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 应用编码
   */
  private String appCode;
  /**
   * 应用ID
   */
  private Long appId;
  /**
   * 应用名称
   */
  private String appName;
  /**
   * 应用类型
   */
  private String appType;
  /**
   * 初始化状态
   */
  private String handleStage;
  /**
   * 初始化说明
   */
  private String remark;
  /**
   * 负责人邮箱
   */
  private String mail;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 代码主仓库地址
   */
  private String gitRepository;
  /**
   * Gitlab仓库
   */
  private String gitlabRepository;
  /**
   * 集成平台项目ID
   */
  private String janusProjectId;
  /**
   * 数据库资源类型
   */
  private String dbType;
  /**
   * 引用AppId
   */
  private Long refAppId;
  /**
   * 所属团队ID
   */
  private Long cmdbGroupId;
  /**
   * Gitlab项目ID
   */
  private Long gitlabProjectId;
  /**
   * 创建人
   */
  private Long createUser;
  /**
   * 修改人
   */
  private Long updateUser;
  /**
   * 版本
   */
  private String version;
  /**
   * 应用定制类型
   */
  private String customType;
  /**
   * 前端代码库
   */
  private String frontGitRepository;
  /**
   * 资源情况原值
   */
  private String resources;
  /**
   * 资源情况
   */
  private String appResources;
  /**
   * 应用用途
   */
  private String appPurpose;
  /**
   * Gitlab组ID
   */
  private Long gitlabGroupId;
  /**
   * Gitlab组名
   */
  private String gitlabGroupName;
  /**
   * 创建时间
   */
  private String createTime1;
  /**
   * 修改时间
   */
  private String updateTime1;
  /**
   * KS工作空间
   */
  private String ksWorkspace;
  /**
   * 默认环境
   */
  private String defaultEnvs;
  /**
   * 团队代码
   */
  private String teamCode;
  /**
   * 模版代码
   */
  private String templateCode;
  /**
   * 启用后端二开代码
   */
  private Boolean enableServiceCode;
  /**
   * 启用前端二开代码
   */
  private Boolean enableFrontendCode;
  /**
   * 启用Bitbucket代码库
   */
  private Boolean enableBitbucket;
  /**
   * 启用Gitlab代码库
   */
  private Boolean enableGitlab;
  /**
   * 启用KS资源准备
   */
  private Boolean enableKs;
  /**
   * 启用关联集成平台项目
   */
  private Boolean enableJanus;
  /**
   * 启用代码模版逻辑
   */
  private Boolean enableTemplateDockerImage;
  /**
   * 启用域名DNS解析配置
   */
  private Boolean enableDns;
  /**
   * 启用Mysql初始化
   */
  private Boolean enableMysql;
  /**
   * 启用用户中心网关配置
   */
  private Boolean enableUserCenterGateway;
  /**
   * 启用用户中心前端应用
   */
  private Boolean enableUserCenterFrontendApp;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("appCode", appCode);
      map.put("appId", appId);
      map.put("appName", appName);
      map.put("appType", appType);
      map.put("handleStage", handleStage);
      map.put("remark", remark);
      map.put("mail", mail);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("gitRepository", gitRepository);
      map.put("gitlabRepository", gitlabRepository);
      map.put("janusProjectId", janusProjectId);
      map.put("dbType", dbType);
      map.put("refAppId", refAppId);
      map.put("cmdbGroupId", cmdbGroupId);
      map.put("gitlabProjectId", gitlabProjectId);
      map.put("createUser", createUser);
      map.put("updateUser", updateUser);
      map.put("version", version);
      map.put("customType", customType);
      map.put("frontGitRepository", frontGitRepository);
      map.put("resources", resources);
      map.put("appResources", appResources);
      map.put("appPurpose", appPurpose);
      map.put("gitlabGroupId", gitlabGroupId);
      map.put("gitlabGroupName", gitlabGroupName);
      map.put("createTime1", createTime1);
      map.put("updateTime1", updateTime1);
      map.put("ksWorkspace", ksWorkspace);
      map.put("defaultEnvs", defaultEnvs);
      map.put("teamCode", teamCode);
      map.put("templateCode", templateCode);
      map.put("enableServiceCode", enableServiceCode);
      map.put("enableFrontendCode", enableFrontendCode);
      map.put("enableBitbucket", enableBitbucket);
      map.put("enableGitlab", enableGitlab);
      map.put("enableKs", enableKs);
      map.put("enableJanus", enableJanus);
      map.put("enableTemplateDockerImage", enableTemplateDockerImage);
      map.put("enableDns", enableDns);
      map.put("enableMysql", enableMysql);
      map.put("enableUserCenterGateway", enableUserCenterGateway);
      map.put("enableUserCenterFrontendApp", enableUserCenterFrontendApp);

      return map;
  }

  public static AppDevOpsEx fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    AppDevOpsEx entity = new AppDevOpsEx();

    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("appName")) {
      Object obj = map.get("appName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appType")) {
      Object obj = map.get("appType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStage")) {
      Object obj = map.get("handleStage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitRepository")) {
      Object obj = map.get("gitRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGitRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitlabRepository")) {
      Object obj = map.get("gitlabRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGitlabRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("janusProjectId")) {
      Object obj = map.get("janusProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJanusProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbType")) {
      Object obj = map.get("dbType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDbType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refAppId")) {
      Object obj = map.get("refAppId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRefAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cmdbGroupId")) {
      Object obj = map.get("cmdbGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCmdbGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCmdbGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCmdbGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gitlabProjectId")) {
      Object obj = map.get("gitlabProjectId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGitlabProjectId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGitlabProjectId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGitlabProjectId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUser((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUser((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customType")) {
      Object obj = map.get("customType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontGitRepository")) {
      Object obj = map.get("frontGitRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrontGitRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resources")) {
      Object obj = map.get("resources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appResources")) {
      Object obj = map.get("appResources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appPurpose")) {
      Object obj = map.get("appPurpose");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppPurpose((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitlabGroupId")) {
      Object obj = map.get("gitlabGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGitlabGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGitlabGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGitlabGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gitlabGroupName")) {
      Object obj = map.get("gitlabGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGitlabGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createTime1")) {
      Object obj = map.get("createTime1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateTime1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateTime1")) {
      Object obj = map.get("updateTime1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateTime1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ksWorkspace")) {
      Object obj = map.get("ksWorkspace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsWorkspace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("defaultEnvs")) {
      Object obj = map.get("defaultEnvs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDefaultEnvs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("teamCode")) {
      Object obj = map.get("teamCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTeamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("templateCode")) {
      Object obj = map.get("templateCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTemplateCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enableServiceCode")) {
      Object obj = map.get("enableServiceCode");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableServiceCode((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableServiceCode(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableFrontendCode")) {
      Object obj = map.get("enableFrontendCode");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableFrontendCode((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableFrontendCode(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableBitbucket")) {
      Object obj = map.get("enableBitbucket");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableBitbucket((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableBitbucket(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableGitlab")) {
      Object obj = map.get("enableGitlab");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableGitlab((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableGitlab(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableKs")) {
      Object obj = map.get("enableKs");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableKs((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableKs(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableJanus")) {
      Object obj = map.get("enableJanus");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableJanus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableJanus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableTemplateDockerImage")) {
      Object obj = map.get("enableTemplateDockerImage");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableTemplateDockerImage((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableTemplateDockerImage(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableDns")) {
      Object obj = map.get("enableDns");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableDns((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableDns(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableMysql")) {
      Object obj = map.get("enableMysql");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableMysql((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableMysql(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableUserCenterGateway")) {
      Object obj = map.get("enableUserCenterGateway");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableUserCenterGateway((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableUserCenterGateway(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableUserCenterFrontendApp")) {
      Object obj = map.get("enableUserCenterFrontendApp");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setEnableUserCenterFrontendApp((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEnableUserCenterFrontendApp(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("appName")) {
      Object obj = map.get("appName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appType")) {
      Object obj = map.get("appType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStage")) {
      Object obj = map.get("handleStage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mail")) {
      Object obj = map.get("mail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitRepository")) {
      Object obj = map.get("gitRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGitRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitlabRepository")) {
      Object obj = map.get("gitlabRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGitlabRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("janusProjectId")) {
      Object obj = map.get("janusProjectId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setJanusProjectId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbType")) {
      Object obj = map.get("dbType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDbType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refAppId")) {
      Object obj = map.get("refAppId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRefAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRefAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRefAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cmdbGroupId")) {
      Object obj = map.get("cmdbGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCmdbGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCmdbGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCmdbGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gitlabProjectId")) {
      Object obj = map.get("gitlabProjectId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGitlabProjectId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGitlabProjectId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGitlabProjectId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUser((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUser((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUser(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUser(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("version")) {
      Object obj = map.get("version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customType")) {
      Object obj = map.get("customType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontGitRepository")) {
      Object obj = map.get("frontGitRepository");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFrontGitRepository((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resources")) {
      Object obj = map.get("resources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appResources")) {
      Object obj = map.get("appResources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appPurpose")) {
      Object obj = map.get("appPurpose");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppPurpose((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gitlabGroupId")) {
      Object obj = map.get("gitlabGroupId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGitlabGroupId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGitlabGroupId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGitlabGroupId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gitlabGroupName")) {
      Object obj = map.get("gitlabGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGitlabGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createTime1")) {
      Object obj = map.get("createTime1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateTime1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateTime1")) {
      Object obj = map.get("updateTime1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateTime1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ksWorkspace")) {
      Object obj = map.get("ksWorkspace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKsWorkspace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("defaultEnvs")) {
      Object obj = map.get("defaultEnvs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDefaultEnvs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("teamCode")) {
      Object obj = map.get("teamCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTeamCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("templateCode")) {
      Object obj = map.get("templateCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTemplateCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enableServiceCode")) {
      Object obj = map.get("enableServiceCode");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableServiceCode((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableServiceCode(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableFrontendCode")) {
      Object obj = map.get("enableFrontendCode");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableFrontendCode((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableFrontendCode(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableBitbucket")) {
      Object obj = map.get("enableBitbucket");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableBitbucket((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableBitbucket(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableGitlab")) {
      Object obj = map.get("enableGitlab");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableGitlab((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableGitlab(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableKs")) {
      Object obj = map.get("enableKs");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableKs((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableKs(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableJanus")) {
      Object obj = map.get("enableJanus");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableJanus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableJanus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableTemplateDockerImage")) {
      Object obj = map.get("enableTemplateDockerImage");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableTemplateDockerImage((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableTemplateDockerImage(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableDns")) {
      Object obj = map.get("enableDns");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableDns((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableDns(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableMysql")) {
      Object obj = map.get("enableMysql");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableMysql((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableMysql(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableUserCenterGateway")) {
      Object obj = map.get("enableUserCenterGateway");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableUserCenterGateway((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableUserCenterGateway(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("enableUserCenterFrontendApp")) {
      Object obj = map.get("enableUserCenterFrontendApp");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setEnableUserCenterFrontendApp((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEnableUserCenterFrontendApp(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
  }
}
