package com.xforceplus.ultraman.app.ultramanoamanager.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * app_devops_env_ex
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AppDevopsEnvEx implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 应用ID
   */
  private Long appId;
  /**
   * 集群空间
   */
  private String namespace;
  /**
   * 服务域名
   */
  private String serviceHost;
  /**
   * 前端域名
   */
  private String frontendHost;
  /**
   * 前端微模块ID
   */
  private String frontendMicroAppId;
  /**
   * 前端应用ID
   */
  private String appSettingId;
  /**
   * 数据库域名
   */
  private String dbHost;
  /**
   * SDK版本
   */
  private String sdkVersion;
  /**
   * 网关路径
   */
  private String gatewayPath;
  /**
   * 资源情况原值
   */
  private String resources;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 创建人
   */
  private String createUser;
  /**
   * 修改人
   */
  private String updateUser;
  /**
   * 元数据部署版本
   */
  private String deployVersion;
  /**
   * 元数据部署说明
   */
  private String deployRemark;
  /**
   * 环境ID
   */
  private String envId;
  /**
   * 资源情况
   */
  private String appEnvResourcesFlag;
  /**
   * 资源情况
   */
  private String appEnvResources;
  /**
   * 应用编码
   */
  private String appCode;
  /**
   * KS工作空间
   */
  private String ksWorkspace;
  /**
   * 集群代码
   */
  private String clusterCode;

  /**
   * 对一关联关系 关联对象 appDevOpsEx
   */
  private Long manyToOneId;
  /**
   * 对一关联关系 关联对象 appDevOpsEx
   */
  private Long oneToManyId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("appId", appId);
      map.put("namespace", namespace);
      map.put("serviceHost", serviceHost);
      map.put("frontendHost", frontendHost);
      map.put("frontendMicroAppId", frontendMicroAppId);
      map.put("appSettingId", appSettingId);
      map.put("dbHost", dbHost);
      map.put("sdkVersion", sdkVersion);
      map.put("gatewayPath", gatewayPath);
      map.put("resources", resources);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("createUser", createUser);
      map.put("updateUser", updateUser);
      map.put("deployVersion", deployVersion);
      map.put("deployRemark", deployRemark);
      map.put("envId", envId);
      map.put("appEnvResourcesFlag", appEnvResourcesFlag);
      map.put("appEnvResources", appEnvResources);
      map.put("appCode", appCode);
      map.put("ksWorkspace", ksWorkspace);
      map.put("clusterCode", clusterCode);

      map.put("manyToOne.id", manyToOneId);
      map.put("oneToMany.id", oneToManyId);
      return map;
  }

  public static AppDevopsEnvEx fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    AppDevopsEnvEx entity = new AppDevopsEnvEx();

    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("namespace")) {
      Object obj = map.get("namespace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNamespace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceHost")) {
      Object obj = map.get("serviceHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontendHost")) {
      Object obj = map.get("frontendHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrontendHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontendMicroAppId")) {
      Object obj = map.get("frontendMicroAppId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrontendMicroAppId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appSettingId")) {
      Object obj = map.get("appSettingId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppSettingId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbHost")) {
      Object obj = map.get("dbHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDbHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sdkVersion")) {
      Object obj = map.get("sdkVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSdkVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gatewayPath")) {
      Object obj = map.get("gatewayPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGatewayPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resources")) {
      Object obj = map.get("resources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployVersion")) {
      Object obj = map.get("deployVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployRemark")) {
      Object obj = map.get("deployRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("envId")) {
      Object obj = map.get("envId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnvId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appEnvResourcesFlag")) {
      Object obj = map.get("appEnvResourcesFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppEnvResourcesFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appEnvResources")) {
      Object obj = map.get("appEnvResources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppEnvResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ksWorkspace")) {
      Object obj = map.get("ksWorkspace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsWorkspace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clusterCode")) {
      Object obj = map.get("clusterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClusterCode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("manyToOne.id")) {
       Object obj = map.get("manyToOne.id");
       if(obj instanceof Long) {
         entity.setManyToOneId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setManyToOneId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("oneToMany.id")) {
       Object obj = map.get("oneToMany.id");
       if(obj instanceof Long) {
         entity.setOneToManyId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setOneToManyId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("appId")) {
      Object obj = map.get("appId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAppId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("namespace")) {
      Object obj = map.get("namespace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNamespace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceHost")) {
      Object obj = map.get("serviceHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontendHost")) {
      Object obj = map.get("frontendHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFrontendHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("frontendMicroAppId")) {
      Object obj = map.get("frontendMicroAppId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFrontendMicroAppId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appSettingId")) {
      Object obj = map.get("appSettingId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppSettingId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dbHost")) {
      Object obj = map.get("dbHost");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDbHost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sdkVersion")) {
      Object obj = map.get("sdkVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSdkVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gatewayPath")) {
      Object obj = map.get("gatewayPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGatewayPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("resources")) {
      Object obj = map.get("resources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUser")) {
      Object obj = map.get("createUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUser")) {
      Object obj = map.get("updateUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployVersion")) {
      Object obj = map.get("deployVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeployVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployRemark")) {
      Object obj = map.get("deployRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeployRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("envId")) {
      Object obj = map.get("envId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEnvId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appEnvResourcesFlag")) {
      Object obj = map.get("appEnvResourcesFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppEnvResourcesFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appEnvResources")) {
      Object obj = map.get("appEnvResources");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppEnvResources((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appCode")) {
      Object obj = map.get("appCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ksWorkspace")) {
      Object obj = map.get("ksWorkspace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setKsWorkspace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("clusterCode")) {
      Object obj = map.get("clusterCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClusterCode((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("manyToOne.id")) {
    Object obj = map.get("manyToOne.id");
    if(obj instanceof Long) {
        this.setManyToOneId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setManyToOneId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("oneToMany.id")) {
    Object obj = map.get("oneToMany.id");
    if(obj instanceof Long) {
        this.setOneToManyId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setOneToManyId(Long.parseLong((String)obj));
    }
  }
  }
}
