package com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(EnvType.class)) {
            isValid = null != EnvType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnvType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(AtomicStatus.class)) {
            isValid = null != AtomicStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AtomicStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ClusterType.class)) {
            isValid = null != ClusterType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ClusterType.class.getSimpleName());
            }
        }
        if(clazz.equals(AppType.class)) {
            isValid = null != AppType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppType.class.getSimpleName());
            }
        }
        if(clazz.equals(SkipEnvCheck.class)) {
            isValid = null != SkipEnvCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SkipEnvCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(ForntTemStatus.class)) {
            isValid = null != ForntTemStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ForntTemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DbType.class)) {
            isValid = null != DbType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DbType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandlerStage.class)) {
            isValid = null != HandlerStage.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandlerStage.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomType.class)) {
            isValid = null != CustomType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomType.class.getSimpleName());
            }
        }
        if(clazz.equals(AppEnvResources.class)) {
            isValid = null != AppEnvResources.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppEnvResources.class.getSimpleName());
            }
        }
        if(clazz.equals(KsWorkspace.class)) {
            isValid = null != KsWorkspace.fromCode(value);
            if(!isValid) {
                unValidMsg(context, KsWorkspace.class.getSimpleName());
            }
        }
        if(clazz.equals(AppPurpose.class)) {
            isValid = null != AppPurpose.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppPurpose.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
