package com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-17
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(EnvType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnvType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnvType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(AtomicStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AtomicStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AtomicStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ClusterType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ClusterType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ClusterType.class.getSimpleName());
            }
        }
        if(clazz.equals(AppType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AppType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AppType.class.getSimpleName());
            }
        }
        if(clazz.equals(SkipEnvCheck.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SkipEnvCheck.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SkipEnvCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(ForntTemStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ForntTemStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ForntTemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DbType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DbType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DbType.class.getSimpleName());
            }
        }
        if(clazz.equals(HandlerStage.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandlerStage.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandlerStage.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CustomType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CustomType.class.getSimpleName());
            }
        }
        if(clazz.equals(AppEnvResources.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AppEnvResources.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AppEnvResources.class.getSimpleName());
            }
        }
        if(clazz.equals(KsWorkspace.class)) {
            isValid = vals.stream()
                    .filter(val -> null != KsWorkspace.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, KsWorkspace.class.getSimpleName());
            }
        }
        if(clazz.equals(AppPurpose.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AppPurpose.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AppPurpose.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
