package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 部署集群类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-07
 */
public enum ClusterType {

    PSCC_NORMAL("pscc_normal", "交付测试集群"),
    ALIYUN_NORMAL("aliyun_normal", "研发测试集群"),
    PSCC_PROD("pscc_prod", "交付生产集群"),
    ALIYUN_PROD("aliyun_prod", "研发生产集群");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ClusterType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ClusterType fromCode(String code) {
        return Stream.of(ClusterType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
