package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 环境类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-07
 */
public enum EnvType {

    _0("0", "DEV"),
    _1("1", "FAT"),
    _2("2", "PROD"),
    _3("3", "SIT"),
    _4("4", "DEMO");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnvType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnvType fromCode(String code) {
        return Stream.of(EnvType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
