package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 跳过无环境校验
 * </p>
 *
 * @author ultraman
 * @since 2023-06-07
 */
public enum SkipEnvCheck {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SkipEnvCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SkipEnvCheck fromCode(String code) {
        return Stream.of(SkipEnvCheck.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
