package com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 申请状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-07
 */
public enum Status {

    _0("0", "草稿"),
    _1("1", "待审批"),
    _2("2", "驳回"),
    _3("3", "通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code) {
        return Stream.of(Status.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
