package com.xforceplus.ultraman.app.ultramanoamanager.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-06-07
*/
public class EntityMeta {
    public interface AppInfo {
        static Long id() {
            return 1403280422815043585L;
        }
        static String code() {
            return "appInfo";
        }
        TypedField<String> APP_CODE = new TypedField<>(String.class, "appCode");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "appId");
        TypedField<String> APP_NAME = new TypedField<>(String.class, "appName");
        TypedField<String> APP_DEVELOPER = new TypedField<>(String.class, "appDeveloper");
        TypedField<String> APP_TYPE = new TypedField<>(String.class, "appType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ATOMIC_STATUS = new TypedField<>(String.class, "atomicStatus");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> MAIL = new TypedField<>(String.class, "mail");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> GIT_REPOSITORY = new TypedField<>(String.class, "gitRepository");
        TypedField<String> CI_LINK = new TypedField<>(String.class, "ciLink");
        TypedField<String> IP = new TypedField<>(String.class, "ip");
        TypedField<String> COMMAND = new TypedField<>(String.class, "command");
        TypedField<String> SKIP_ENV_CHECK = new TypedField<>(String.class, "skipEnvCheck");
        TypedField<String> FORNT_TEM_STATUS = new TypedField<>(String.class, "forntTemStatus");
        TypedField<String> JANUS_PROJECT_ID = new TypedField<>(String.class, "janusProjectId");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface EnvInfo {
        static Long id() {
            return 1403286428223451138L;
        }
        static String code() {
            return "envInfo";
        }
        TypedField<String> ENV_TYPE = new TypedField<>(String.class, "envType");
        TypedField<String> CLUSTER_TYPE = new TypedField<>(String.class, "clusterType");
        TypedField<String> NAMESPACE = new TypedField<>(String.class, "namespace");
        TypedField<String> FRONT_ADRESS = new TypedField<>(String.class, "frontAdress");
        TypedField<String> BACK_END_ADRESS = new TypedField<>(String.class, "backEndAdress");
        TypedField<String> BACK_END_SVC = new TypedField<>(String.class, "backEndSvc");
        TypedField<Boolean> USER_CENTER_ENABLE = new TypedField<>(Boolean.class, "userCenterEnable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 appInfo
         */
        TypedField<Long> ENV_DETAILS_ID = new TypedField<>(Long.class, "envDetails.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ENV_DETAILS {
                static String code () {
                    return "envDetails" ;
                }
                TypedField<String> APP_CODE = new TypedField<>(String.class, "envDetails.appCode");
                TypedField<Long> APP_ID = new TypedField<>(Long.class, "envDetails.appId");
                TypedField<String> APP_NAME = new TypedField<>(String.class, "envDetails.appName");
                TypedField<String> APP_DEVELOPER = new TypedField<>(String.class, "envDetails.appDeveloper");
                TypedField<String> APP_TYPE = new TypedField<>(String.class, "envDetails.appType");
                TypedField<String> STATUS = new TypedField<>(String.class, "envDetails.status");
                TypedField<String> ATOMIC_STATUS = new TypedField<>(String.class, "envDetails.atomicStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "envDetails.remark");
                TypedField<String> MAIL = new TypedField<>(String.class, "envDetails.mail");
                TypedField<Long> ID = new TypedField<>(Long.class, "envDetails.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "envDetails.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "envDetails.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "envDetails.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "envDetails.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "envDetails.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "envDetails.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "envDetails.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "envDetails.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "envDetails.delete_flag");
                TypedField<String> GIT_REPOSITORY = new TypedField<>(String.class, "envDetails.gitRepository");
                TypedField<String> CI_LINK = new TypedField<>(String.class, "envDetails.ciLink");
                TypedField<String> IP = new TypedField<>(String.class, "envDetails.ip");
                TypedField<String> COMMAND = new TypedField<>(String.class, "envDetails.command");
                TypedField<String> SKIP_ENV_CHECK = new TypedField<>(String.class, "envDetails.skipEnvCheck");
                TypedField<String> FORNT_TEM_STATUS = new TypedField<>(String.class, "envDetails.forntTemStatus");
                TypedField<String> JANUS_PROJECT_ID = new TypedField<>(String.class, "envDetails.janusProjectId");
            }
        }
    }
    public interface FrontPageCode {
        static Long id() {
            return 1578567584018771969L;
        }
        static String code() {
            return "frontPageCode";
        }
        TypedField<String> FORNT_TEM_STATUS = new TypedField<>(String.class, "forntTemStatus");
        TypedField<String> PAGE_CODE = new TypedField<>(String.class, "pageCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 appInfo
         */
        TypedField<Long> APP_INFO_ONE_TO_MANY_PAGES_ID = new TypedField<>(Long.class, "appInfoOneToManyPages.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface APP_INFO_ONE_TO_MANY_PAGES {
                static String code () {
                    return "appInfoOneToManyPages" ;
                }
                TypedField<String> APP_CODE = new TypedField<>(String.class, "appInfoOneToManyPages.appCode");
                TypedField<Long> APP_ID = new TypedField<>(Long.class, "appInfoOneToManyPages.appId");
                TypedField<String> APP_NAME = new TypedField<>(String.class, "appInfoOneToManyPages.appName");
                TypedField<String> APP_DEVELOPER = new TypedField<>(String.class, "appInfoOneToManyPages.appDeveloper");
                TypedField<String> APP_TYPE = new TypedField<>(String.class, "appInfoOneToManyPages.appType");
                TypedField<String> STATUS = new TypedField<>(String.class, "appInfoOneToManyPages.status");
                TypedField<String> ATOMIC_STATUS = new TypedField<>(String.class, "appInfoOneToManyPages.atomicStatus");
                TypedField<String> REMARK = new TypedField<>(String.class, "appInfoOneToManyPages.remark");
                TypedField<String> MAIL = new TypedField<>(String.class, "appInfoOneToManyPages.mail");
                TypedField<Long> ID = new TypedField<>(Long.class, "appInfoOneToManyPages.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "appInfoOneToManyPages.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "appInfoOneToManyPages.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "appInfoOneToManyPages.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "appInfoOneToManyPages.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "appInfoOneToManyPages.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "appInfoOneToManyPages.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "appInfoOneToManyPages.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "appInfoOneToManyPages.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "appInfoOneToManyPages.delete_flag");
                TypedField<String> GIT_REPOSITORY = new TypedField<>(String.class, "appInfoOneToManyPages.gitRepository");
                TypedField<String> CI_LINK = new TypedField<>(String.class, "appInfoOneToManyPages.ciLink");
                TypedField<String> IP = new TypedField<>(String.class, "appInfoOneToManyPages.ip");
                TypedField<String> COMMAND = new TypedField<>(String.class, "appInfoOneToManyPages.command");
                TypedField<String> SKIP_ENV_CHECK = new TypedField<>(String.class, "appInfoOneToManyPages.skipEnvCheck");
                TypedField<String> FORNT_TEM_STATUS = new TypedField<>(String.class, "appInfoOneToManyPages.forntTemStatus");
                TypedField<String> JANUS_PROJECT_ID = new TypedField<>(String.class, "appInfoOneToManyPages.janusProjectId");
            }
        }
    }
    public interface AppOrigin {
        static Long id() {
            return 1648862385905123330L;
        }
        static String code() {
            return "appOrigin";
        }
        TypedField<String> PROJECT_ID = new TypedField<>(String.class, "projectId");
        TypedField<String> AUTH_APP_ID = new TypedField<>(String.class, "authAppId");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<String> ALIAS = new TypedField<>(String.class, "alias");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> VERSION = new TypedField<>(String.class, "version");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> APP_ID = new TypedField<>(String.class, "appId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
