package com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.ultramanoamanager.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-07
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(EnvType.class)) {
            isValid = null != EnvType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnvType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(AtomicStatus.class)) {
            isValid = null != AtomicStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AtomicStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ClusterType.class)) {
            isValid = null != ClusterType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ClusterType.class.getSimpleName());
            }
        }
        if(clazz.equals(AppType.class)) {
            isValid = null != AppType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AppType.class.getSimpleName());
            }
        }
        if(clazz.equals(SkipEnvCheck.class)) {
            isValid = null != SkipEnvCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SkipEnvCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(ForntTemStatus.class)) {
            isValid = null != ForntTemStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ForntTemStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
